﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace Reversi
{
    public partial class Form1 : Form
    {
        private Button[,] plansza = new Button[ReversiSilnik.planszaSzer, ReversiSilnik.planszaWys];
        private ReversiSilnik silnik = new ReversiSilnik(1);

        private Color[] kolory = { Color.Ivory, Color.Green, Color.Sienna };

        private bool PlanszaZainicjowana
        {
            get
            {
                return plansza[ReversiSilnik.planszaSzer - 1, ReversiSilnik.planszaWys - 1] != null;
            }
        }

        private void dopasujRozmiarPlanszy()
        {
            if (!PlanszaZainicjowana) return;

            Rectangle rozmiarOkna = this.ClientRectangle;

            //ustalanie rozmiaru przycisku
            int rozmiarPlanszy = Math.Min(rozmiarOkna.Width, rozmiarOkna.Height);
            int przyciskSzer = rozmiarPlanszy / ReversiSilnik.planszaSzer;
            int przyciskWys = rozmiarPlanszy / ReversiSilnik.planszaWys;

            //ustalanie pozycji przycisku
            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                    plansza[i, j].Bounds = new Rectangle(i * przyciskSzer, 1 + j * przyciskWys, przyciskSzer, przyciskWys);
        }

        private void uzgodnijZawartoscPlanszy()
        {
            if (!PlanszaZainicjowana) return;

            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                {                    
                    //plansza[i, j].Text = silnik.StanPola(i, j).ToString();
                    plansza[i, j].BackColor = kolory[silnik.StanPola(i, j)];
                }
        }

        public Form1()
        {
            InitializeComponent();            

            //ustalanie rozmiaru przycisku
            int przyciskSzer = this.ClientSize.Width / ReversiSilnik.planszaSzer;
            int przyciskWys = this.ClientSize.Height / ReversiSilnik.planszaWys;

            //tworzenie przyciskow
            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                {
                    plansza[i, j] = new Button();
                    plansza[i, j].Parent = this;
                    plansza[i, j].Click += new EventHandler(kliknieciePolaPlanszy);
                }

            dopasujRozmiarPlanszy();
            uzgodnijZawartoscPlanszy();

            //test
            //silnik.PolozKamien(2, 4);
            //uzgodnijZawartoscPlanszy();
        }

        void kliknieciePolaPlanszy(object sender, EventArgs e)
        {
            //szukamy pola planszy odpowiadającego kliknietemu przyciskowi
            int kliknietePoziomo = -1, kliknietePionowo = -1;
            for (int i = 0; i < ReversiSilnik.planszaSzer; i++)
                for (int j = 0; j < ReversiSilnik.planszaWys; j++)
                    if (sender == plansza[i, j])
                    {
                        kliknietePoziomo = i;
                        kliknietePionowo = j;
                    }

            //jezeli nie znaleziony - zglaszanie bledu
            if (kliknietePoziomo == -1 || kliknietePionowo == -1)
                throw new Exception("Nie zidentyfikowane pole planszy");

            //w przeciwnym razie - wykonanie ruchu
            int zapamietanyNumerGracza = silnik.NumerGraczaWykonujacegoNastepnyRuch;
            if (silnik.PolozKamien(kliknietePoziomo, kliknietePionowo))
            {
                uzgodnijZawartoscPlanszy();
            }
        }
    }
}